<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
class Mailformat {
	private $CI;
	public function __construct()
	{
		$this->CI =& get_instance();
		$this->CI->load->helper("htmlpurifier");
		$this->CI->load->library('session');
	}
	
	public function mailbox_list_format($mailboxes,$resource,$host,$port,$service_flags) {		
		$mailbox_list = "<ul id=\"mailbox_list\">";
		$mailbox_group = $this->CI->session->userdata('mailbox_group');
		
		if(strlen(trim($mailbox_group)) > 0 && $mailbox_group != $this->CI->session->userdata("username")) { $inbox_str = "{" . IMAP_HOSTNAME . ":" . IMAP_PORT .  IMAP_SERVICEFLAGS . "}" . GROUP_MAILBOX_PREFIX .'.'.$mailbox_group.'.'."INBOX"; }
		else { $inbox_str = "{" . IMAP_HOSTNAME . ":" . IMAP_PORT .  IMAP_SERVICEFLAGS . "}INBOX"; }
		$inbox_location = array_search($inbox_str, $mailboxes);
		$mailboxes[$inbox_location] = 0; 
		$mailboxes = array_filter($mailboxes);
		$mailboxes = array_merge(array($inbox_str), $mailboxes);
		
		$custom_mailboxes = array();
		$i = 0;
		foreach($mailboxes as $mailbox) {
			if(strpos($mailbox,CUSTOM_MAILBOX_PREFIX) !== FALSE) { array_push($custom_mailboxes,$mailbox); $mailboxes[$i] = 0; }
			$i++;
		}
		$mailboxes = array_filter($mailboxes);
		$mailboxes = array_merge($mailboxes,$custom_mailboxes);
		
		$i = 0;
		foreach($mailboxes as $mailbox) {
			//save mailbox connection string before it gets reformatted
			$mailbox_conn_string = $mailbox;
					
			//get the unseen message count for the mailbox if it exists
			$unseen = (isset(imap_status($resource,$mailbox_conn_string,SA_UNSEEN)->unseen)) ? (imap_status($resource,$mailbox_conn_string,SA_UNSEEN)->unseen) : (0);
			if($unseen > 0) { $show_unseen = " (" . $unseen . ")"; }
			else { $show_unseen = ""; }
					
			//reformat mailbox connection string to just get the mailbox name
			$mailbox = str_replace("{" . $host . ":" . $port . $service_flags . "}","",$mailbox);
			
			//variable to see if we will display this mailbox in the menu or not
			$display_mailbox = TRUE;
			
			//check if group mailboxes need to be accounted for
			if(strlen(trim($mailbox_group)) > 0) {
				if($mailbox_group != $this->CI->session->userdata('username')) {
						if($i == 0) { $mailbox_list .= '<li class="nohover" title="'.$this->CI->session->userdata('mailbox_group_cn').'"><div style="text-overflow: ellipsis; overflow: hidden; white-space: nowrap;">' . $this->CI->session->userdata('mailbox_group_cn') . '</div></li>'; }
						if($this->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.',"") == $mailbox) { $display_mailbox = FALSE; }
						if($this->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.',"") == $mailbox) { $display_mailbox = FALSE; }
				}
				else {
					if($this->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.',"") != $mailbox) { $display_mailbox = FALSE; }
				}
			}
			
			//create mailbox list components
			if($this->replaceFirst($mailbox,CUSTOM_MAILBOX_PREFIX,"") != $mailbox) {
				$mailbox = $this->replaceFirst($mailbox,CUSTOM_MAILBOX_PREFIX,"");
				if($menuClass == "systemFolder") { 
					$menuClass = "firstCustomFolder";
					//only display create folder option for non-group mailboxes
					if($this->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.',"") == $mailbox && (strlen(trim($mailbox_group)) <= 0 || $mailbox_group == $this->CI->session->userdata('username'))) {
						$mailbox_list .= "<li class=\"nohover\"><span style=\"display:block;width:140px;margin-top:5px;height:1px solid #bbb;border-bottom:1px dotted #999;\"></span></li>";
						$mailbox_list .= '<li class="systemFolder"><img src="/images/yellow_folder_add.png" alt="Create Folder Icon"/><a class="mbox" onclick= "createFolder();" href="#" title="Create Folder">Create Folder</a></li>';
						$add_create_folder = TRUE; //keep track of the fact we have create folder menu added
					}
				} else { 
					$menuClass = "customFolder";
				}
				//set custom folder menus
				$mailbox_hash = hash('sha256',($mailbox));
				$menu = "<span id=\"" . $mailbox_hash . "\" class=\"menu\">&#9660;</span>";
				$menu .= '<span id="custom_folder_name" style="display: none;">' . $mailbox . '</span>';
				$accessibility_menu = 	'<a id="archive_folder_'.$mailbox_hash.'" class="hidden_context" href="/inbox/archive_folder/'.rawurlencode(base64_encode($mailbox)).'">Archive Folder: '.$mailbox.'</a>'.
										form_hidden('old_value_'.$mailbox_hash, $mailbox, 'old_value_'.$mailbox_hash).
										'<label id="rename_folder_label_'.$mailbox_hash.'" for="rename_folder_'.$mailbox_hash.'" class="hidden_context">Rename Folder</label>'.
										'<input class="hidden_context" name="rename_folder_'.$mailbox_hash.'" id="rename_folder_'.$mailbox_hash.'" type="button" value="Rename Folder" onclick="'.
                                        '$(\'[id=&quot;'.$mailbox_hash.'&quot;]\').parent().children(\'#custom_folder_name\').css(\'display\',\'inline\');'.
                                        '$(\'[id=&quot;'.$mailbox_hash.'&quot;]\').parent().children(\'a\').css(\'display\',\'none\');'.
                                        '$(\'[id=&quot;'.$mailbox_hash.'&quot;]\').parent().children(\'#custom_folder_name\').editable(\'/inbox/rename_folder/'.
                                        rawurlencode(base64_encode($mailbox)).'/\',{ event : \'rename_event\',height: 12,width: 100,style : \'position: relative; float: right; z-index: 100;\', submitdata: {\''.$this->CI->security->get_csrf_token_name().'\': $(\'input[type=&quot;hidden&quot;].token\').val()}, onblur : \'submit\',indicator : \'Saving...\' ,callback: function(value, settings) { $(this).unbind(settings.event);}});'.
                                        '$(\'[id=&quot;'.$mailbox_hash.'&quot;]\').parent().children(\'#custom_folder_name\').trigger(\'rename_event\');"/>';
				//make sure we use the correct set of prefixes based on custom and group mailbox prefixes (and a combination thereof if necesssary)
				$folder_prefix = CUSTOM_MAILBOX_PREFIX;
				if($this->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.',"") != $mailbox) {
					$mailbox = $this->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.'. $mailbox_group . '.',"");
					$menu = "<span id=\"" . str_replace(" ","_",$mailbox) . "\" class=\"menu group\">&#9660;</span>";
					$folder_prefix = GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.' . CUSTOM_MAILBOX_PREFIX;
				}
			}	
			else {
				//if system folder, don't set custom folder menus
				$menuClass = "systemFolder"; $menu = ""; $accessibility_menu = ''; $folder_prefix = "";
				if($this->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.',"") != $mailbox) {
					$mailbox = $this->replaceFirst($mailbox,GROUP_MAILBOX_PREFIX . '.'. $mailbox_group . '.',"");
					$folder_prefix = GROUP_MAILBOX_PREFIX . '.' . $mailbox_group . '.';
				}
			}

			//if there is a current mailbox stored in session
			if(isset($_SESSION['mailbox'])) { 
				//if this mailbox is the current mailbox, make it bold (if not, do not)
				if($mailbox == $_SESSION['mailbox'] || ($folder_prefix . $mailbox) == $_SESSION['mailbox']) { $anchor_class = "cur_mbox"; }
				else { $anchor_class = "mbox"; }
			}
			//if no mailbox in session, we must be on inbox, so make inbox bold
			else if($mailbox == "INBOX") { $anchor_class = "cur_mbox"; }
			//if the mailbox is not inbox and nothing is in session, print it normally
			else { $anchor_class = "mbox"; }
			
			if($display_mailbox == TRUE) {
				$mailbox_list .= '<li class="' . $menuClass .'">' . 
								 '<img style="width: 15px; height: 15px;" src="/images/closed_folder_yellow_icon.png" alt="Folder Icon" />' . 
								 $menu .'<a title="'.$mailbox.$show_unseen.'" class="' . $anchor_class . '" href="' . base_url() . 'inbox/change_mailbox/' . 
								 rawurlencode(base64_encode($folder_prefix . $mailbox)) . '">' . $mailbox . $show_unseen . '</a>';
				$mailbox_list .= '</li>';
				if(strlen($accessibility_menu) > 0) { $mailbox_list .= '<li class="customMailboxAccessibleMenu">'. $accessibility_menu .'</li>'; }
			}
			$i++;
		}
		if(strpos($mailbox_list,"createFolder") === FALSE && (strlen(trim($mailbox_group)) <= 0 || $mailbox_group == $this->CI->session->userdata('username'))) {
			$mailbox_list .= "<li class=\"nohover\"><span style=\"display:block;width:140px;margin-top:5px;height:1px solid #bbb;border-bottom:1px dotted #999;\"></span></li>";
			$mailbox_list .= '<li class="systemFolder"><img src="/images/yellow_folder_add.png" alt="Create Folder Icon"/><a class="mbox" onclick= "createFolder();" href="#" title="Create Folder">Create Folder</a></li>';
			$add_create_folder = TRUE;
		}
		$mailbox_list .="</ul>";
		
		//if we have added create folder, add an accessibility alternative create folder after mailbox list
		return $mailbox_list;
	}
	
	/*  This function is intended to format the data array for the view message inbox view.
	 *  Currently this function breaks down the MIME message object returned by the peeker get_message
	 *  function and populates elements of the data array from the formatted parts of the message.
	 *  TO DO: Improve the flow of this function, break repeated steps into other functions/simplify code.
	 *         To transition to a web service, this function should ideally return JSON or some other 
	 *	   universal format, which the inbox view then processes.
	 */
	public function format_msg_display($msg) {
		$subject = imap_utf8($msg->get_subject());
		if(strlen(trim($subject)) <= 0) { $subject = "(No Subject)"; }
		$data['title'] =  PORTAL_TITLE_PREFIX . htmlentities($subject); //get the subject and set the title of the page to include it
		//if the message has html, display it
		if($msg->get_html() != "") { 
			$html = purify($msg->get_html());
			$html = substr($html,strpos($html,"<body"),strlen($html) - strpos($html,"<body"));
			$html = str_replace("<body","<div",$html);
			$html = str_replace("</body","</div",$html);
			$html = str_replace("</html>","",$html);
			$data['msg_body'] = $html;
		}
		//otherwise display the plain text part of the message
		else { $data['msg_body'] = nl2br($msg->get_plain()); }
		$data['raw_msg_body'] = $data['msg_body'];

		//get all addresses in the from field, and format them for display
		$data['msg_from_array'] = $this->format_address_list_for_display($msg->get_from_array());

		//get all addresses in the to field, and format them for display
		$data['msg_to_array'] = $this->format_address_list_for_display($msg->get_to_array());
		
		//get all addresses in the to field, and format them for display
		$data['msg_cc_array'] = $this->format_address_list_for_display($msg->get_cc_array());
		
		$data['msg_subject'] = htmlentities($subject);
		
		//format date from unix date if set
		$msg_udate = $msg->get_udate();
		$msg_date = $msg->get_date();
		$msg_time_pulled = $msg->timestamp_pulled;
		if(isset($msg_udate) && strlen($msg_udate) > 0) { $udate = $msg_udate; }
		//otherwise use strtotime to get unix date from normal date
		else if(isset($msg_date) && strlen($msg_date) > 0) { $udate = strtotime($msg_date); }
		//try to get the time_pulled if neither of these are set
		else if(isset($msg_time_pulled) && strlen($msg_time_pulled) > 0) { $udate = $msg_time_pulled; }
		else { $data['msg_date'] = "Unknown Date"; $data['msg_date_quote'] = "Unknown Date"; }
		if(isset($udate)) {
			$date = date("n/j/Y g:i A",$udate);
			if(date("n/j/Y",$udate) == date("n/j/Y")) { $date = "Today " . date("g:i A",$udate); } //if date is current date, use time
			$data['msg_date'] = $date;
			$data['msg_date_quote'] = date("n/j/Y g:i A",strtotime($msg->get_date()));
		}
		if($msg->Draft == "X") { $data['draft'] = "true"; } else { $data['draft'] = "false"; }
		if(isset($msg->header_array["X-Priority"])) { 
			if($msg->header_array["X-Priority"] < 3) { $data['priority'] = "high"; }
			else if($msg->header_array["X-Priority"] == 3) { $data['priority'] = "normal";}
			else if($msg->header_array["X-Priority"] > 3) { $data['priority'] = "low"; }
			else { $data['priority'] = "normal"; }
		}
		else if(isset($msg->header_array["Importance"])) { 
			if(strtolower($msg->header_array["Importance"]) == "high") { $data['priority'] = "high"; }
			else if(strtolower($msg->header_array["Importance"]) == "low") { $data['priority'] = "low";}
			else { $data['priority'] = "normal"; }
		}
		else { $data['priority'] = "normal"; }
		
		if($msg->has_attachment()) {
			$data['attachment'] = $msg->get_parts_array();
			foreach($msg->get_parts_array() as $part) {
				if((pathinfo($part->filename, PATHINFO_EXTENSION) == "xml") || strtolower($part->subtype) == "xml") {
					$xml = new DOMDocument; //load xml
					$xml->loadXml($part->string);
					//get schema to check if its a c32
					$schema = $xml->documentElement->getAttribute('xsi:schemaLocation'); 
					if(strpos($schema,"cdar2c32") !== FALSE || strpos($schema,"v3 CDA") !== FALSE) {
						if($xml->getElementsByTagName('code')->item(0)->hasAttribute('displayName')) { $title = $xml->getElementsByTagName('code')->item(0)->getAttribute('displayName'); }
						else if($xml->getElementsByTagName('title')->length > 0) { $title = $xml->getElementsByTagName('title')->item(0)->nodeValue; }
						else { $title = "Clinical Document"; }
						if($xml->getElementsByTagName('patient')->length > 0 && $xml->getElementsByTagName('name')->length > 0) { $patient = $xml->getElementsByTagName('patient')->item(0)->getElementsByTagName('name')->item(0)->nodeValue; }
						if($xml->getElementsByTagName('representedOrganization')->length > 0) { $org = $xml->getElementsByTagName('representedOrganization')->item(0)->getElementsByTagName('name')->item(0)->nodeValue; }
						
						//check for set values that are blnak to avoid confusing information
						if(strlen($title) <= 0) { $title = "C32 Document"; }
						if(isset($patient) && strlen(trim($patient)) <= 0) { $patient = "Unnamed Patient"; }
						if(isset($org) && strlen(trim($org)) <= 0) { $patient = "Unnamed Organization"; }
						
						$data["c32data"][$part->filename] = $title;
						if(isset($patient)) { $data["c32data"][$part->filename] .= " for " . $patient; }
						if(isset($org)) { $data["c32data"][$part->filename] .= " from " . $org; }
					}
				}
			}
		}
		//if the message has at least one inline attachment
		if($msg->has_at_least_one_attachment_with_disposition("INLINE")) {
			$i = 0;
			$body_empty = empty($data['msg_body']);
			//if there is a parts array, then this will replace the cids to display the image
			foreach($data['attachment'] as $attachment) {
				if($attachment->disposition == "INLINE") {
					if($body_empty) { $data['msg_body'] .= "<img src=\"" . base_url() . "inbox/imgdisp/" . $msg->Msgno . "/" . rawurlencode($attachment->filename) . "\" />"; }
					$data['msg_body'] = str_replace("cid:".$attachment->cid,base_url() . "inbox/imgdisp/".$msg->Msgno . "/" . rawurlencode($attachment->filename),$data['msg_body']);
					$i++;
				}
			}
			//if there is no parts array, but there is an inline image, its probably a single image from apple mail
			//with no text, we can do a quick check here to find out and work to display it
			if(isset($msg->header_array["X-Mailer"]) && strpos("Apple",$msg->header_array["X-Mailer"]) >= 0) {
				$subtype = "";
				if(isset($msg->header_array["Content-Disposition"])) { 
					$disp = explode(";",$msg->header_array["Content-Disposition"]);
					foreach($disp as $item) { 
						$item = trim($item);
						if(strpos("filename=",$item) >= 0) {
							
							$arr = explode(".",str_replace("filename=","",$item));
							if(count($arr) > 1) { 
								$filename = $arr[0] . "." . $arr[1];  
								$subtype = $arr[1]; 
							}
						}
					}
					$data['msg_body'] = "<img src=\"" . base_url() . "inbox/imgdisp/" . $msg->Msgno . "/" . rawurlencode($filename) . "/" . $subtype . "\" />";
				}
			}
		}
		return $data;
	}
	
	/* Function designed to strip out repetitive RE's and FWD's from a message subject. Will also replace the most recent RE or FWD
     * with FWD or RE (respectively) if necessary; e.g., forwarding the following message 
	 * RE: Some Subject Here 
	 * ...will instead result in
	 * FWD: Some Subject Here
	*/
	public function msg_subject_sanitize($msg_subject,$type){
		$new_subject = $msg_subject;
		//detect if this is the subject that is already a reply or forward
		$multiple_replies = 	(substr($msg_subject,0,3)=="RE:") || (substr($msg_subject,0,3)=="Re:") || 
								(substr($msg_subject,0,2)=="Fw") || (substr($msg_subject,0,2)== "FW");
								
		//Conditional offset to handle if there is a Re:/Fwd: of some sort already in the subject
		$offset=((substr($msg_subject,0,4)== "FWD:") || (substr($msg_subject,0,4)=="Fwd:")) ? 4 : ($multiple_replies? 3: 0);
		
		//remove previous Re: / Fwd: then add ours
		if($type=="reply" || $type=="replyall") { $new_subject = "Re: ". trim(substr($msg_subject,$offset)); }
		else if($type=="fwd") { $new_subject = "Fwd: " . trim(substr($msg_subject,$offset)); }
		else { return $msg_subject; } //just return original subject if not a reply or forward
		
		return $new_subject;
	}
	
	public function format_display_addresses_for_sending($addresses) {
		$i = 0;
		foreach($addresses as $address) {
			if(strpos($address,"(") > 0) { $address = "\"" . str_replace(" (","\" <",$address); }
			else { $address = str_replace("(","<",$address); }
			$address = str_replace(")",">",$address);
			$addresses[$i] = $address;
			$i++;
		}
		return $addresses;
	}
	
	public function format_address_list_for_display($addresses) {
		$i = 0;
		$address_list = array();
		foreach($addresses as $address) {
			if(isset($address->host) && $address->host == "MISSING_DOMAIN") { unset($address->host); }
			if(isset($address->personal) && isset($address->mailbox) && isset($address->host)) { 
				$address_list[$i] = $address->personal . " (" . $address->mailbox . "@" . $address->host . ")";
			}
			else if(isset($address->mailbox) && isset($address->host)) {
				$address_list[$i] = $address->mailbox . "@" . $address->host;
			}
			else if(isset($address->personal)) { return array($address->personal); }
			else if(isset($address->mailbox)) { return array($address->mailbox); }
			else if(isset($address->host)) { return array($address->host); }
			$i++;
		}
		return $address_list;
	}
	
	//replace first instance of a substring within a string, used for custom mailbox folder replacement for display
	public function replaceFirst($input, $search, $replacement){
		$pos = stripos($input, $search);
		if($pos === false){
			return $input;
		}
		else{
			$result = substr_replace($input, $replacement, $pos, strlen($search));
			return $result;
		}
	}
}
?>